﻿########## SCRIPT-00 ###########
# Ping is for...
Test-Connection www.ufl.edu
# Test-Connection www.ufl.edu | select Address, IPV4Address, ResponseTime
# Ping sweep
# 1..100 | % {"192.168.1.$($_): $(Test-Connection -count 1 -comp 192.168.1.$($_) -quiet)"}
########## SCRIPT-01 ###########
















########## OUTPUT-00 ###########
#
# Source        Destination     IPV4Address    IPV6Address  Bytes    Time(ms)
# ------        -----------     -----------    -----------  -----    --------
# UFAD-GASPE... www.ufl.edu     128.227.9.48                32       1
# UFAD-GASPE... www.ufl.edu     128.227.9.48                32       1
# UFAD-GASPE... www.ufl.edu     128.227.9.48                32       0
# UFAD-GASPE... www.ufl.edu     128.227.9.48                32       0
#
########## SCRIPT-00 ###########


















########## SCRIPT-01 ###########
# Ping is for...
# Check ACLs and firewalls
Test-NetConnection www.ufl.edu -Port 80
########## SCRIPT-01 ###########















########## OUTPUT-01 ###########
#
# ComputerName           : www.ufl.edu
# RemoteAddress          : 128.227.9.48
# RemotePort             : 80
# InterfaceAlias         : vEthernet (vSwitchIntel)
# SourceAddress          : 10.253.17.50
# PingSucceeded          : True
# PingReplyDetails (RTT) : 0 ms
# TcpTestSucceeded       : True
#
########## OUTPUT-01 ###########



















########## SCRIPT-02 ###########
# tracert
Test-NetConnection www.ufl.edu -TraceRoute
########## SCRIPT-02 ###########















########## OUTPUT-02 ###########
#
# ComputerName           : www.ufl.edu
# RemoteAddress          : 128.227.9.48
# InterfaceAlias         : vEthernet (vSwitchIntel)
# SourceAddress          : 10.253.17.50
# PingSucceeded          : True
# PingReplyDetails (RTT) : 1 ms
# TraceRoute             : 10.253.17.1
#                          128.227.172.25
#                          128.227.236.144
#                          128.227.236.153
#                          128.227.9.48
# 
########## OUTPUT-02 ###########














########## SCRIPT-03 ###########
# nslookup, dig
Resolve-DnsName www.ufl.edu
########## SCRIPT-03 ###########

















########## OUTPUT-03 ###########
#
# Name                           Type   TTL   Section    NameHost                                                                                   
# ----                           ----   ---   -------    --------                                                                                   
# www.ufl.edu                    CNAME  300   Answer     onsite.webadmin.ufl.edu                                                                    
# onsite.webadmin.ufl.edu        CNAME  300   Answer     virtual-webadmin-prod02.osg.ufl.edu                                                        
# 
# Name       : virtual-webadmin-prod02.osg.ufl.edu
# QueryType  : A
# TTL        : 300
# Section    : Answer
# IP4Address : 128.227.9.48
# 
# 
# Name                   : osg.ufl.edu
# QueryType              : SOA
# TTL                    : 300
# Section                : Authority
# NameAdministrator      : net-services.ufl.edu
# SerialNumber           : 330187081
# TimeToZoneRefresh      : 500
# TimeToZoneFailureRetry : 200
# TimeToExpiration       : 2419200
# DefaultTTL             : 1800
# 
########## OUTPUT-03 ###########














########## SCRIPT-04 ###########
# Reverse lookup
Resolve-DnsName 128.227.9.48
########## SCRIPT-04 ###########
















########## OUTPUT-04 ###########
#
# Name                           Type   TTL   Section    NameHost                                                                                   
# ----                           ----   ---   -------    --------                                                                                   
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     ufl.edu                                                                                    
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     virtual-webadmin-prod02.osg.ufl.edu                                                        
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     ufl.com                                                                                    
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     ufl.net                                                                                    
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     ufl.org                                                                                    
# 48.9.227.128.in-addr.arpa      PTR    300   Answer     uf.edu                                      
# 
########## OUTPUT-04 ###########













########## SCRIPT-04 ###########
Resolve-DnsName ufl.edu -Type MX
########## SCRIPT-04 ###########
















########## OUTPUT-04 ###########
#
# Name      Type   TTL   Section    NameExchange                      Preference                             
# ----      ----   ---   -------    ------------                      ----------                             
# ufl.edu   MX     900   Answer     virtual-smtp-prod01.osg.ufl.edu   10                                     
# ufl.edu   MX     900   Answer     smtp-prod02.osg.ufl.edu           20                                     
# ufl.edu   MX     900   Answer     smtp-prod01.osg.ufl.edu           20                                     
# ufl.edu   MX     900   Answer     smtp-prod04.osg.ufl.edu           20                                     
# ufl.edu   MX     900   Answer     smtp-prod03.osg.ufl.edu           20                                     
# ufl.edu   MX     900   Answer     smtp-prod06.osg.ufl.edu           20                                     
# ufl.edu   MX     900   Answer     smtp-prod05.osg.ufl.edu           20                                     
# 
########## OUTPUT-04 ###########




















########## SCRIPT-05 ###########
#Wi-Fi Connection Information
$data = (netsh wlan show networks mode=Bssid | 
    where {$_ -like "SSID*" -or $_ -like "*Authentication*" -or $_ -like "*Encryption*" -or $_ -like "*Signal*"}).trim()   
$result = for ( $i = 0; $i -lt $data.count; ) {
    '' | Select @{n='Connection';e={($data[$i].split(':')[1]).trim()}}, 
    @{n='Authentication';e={($data[$i+1].split(':')[1]).trim()}}, 
    @{n='Encryption';e={($data[$i+2].split(':')[1]).trim()}}, 
    @{n='Signal';e={($data[$i+3].split(':')[1]).trim()}}
    $i = $i + 4
}
Return $result
########## SCRIPT-05 ###########


















########## OUTPUT-05 ###########
#
# Connection         Authentication Encryption Signal
# ----------         -------------- ---------- ------
# g33k               WPA2-Personal  CCMP       99%   
# BuckelPferdchen-5G WPA2-Personal  CCMP       41%   
# Nathalie           WPA2-Personal  CCMP       99%   
# BuckelPferdchen    WPA2-Personal  CCMP       58%   
#
########## OUTPUT-05 ###########

















########## SCRIPT-06 ###########
#https://blogs.msdn.microsoft.com/mssmallbiz/2016/07/10/how-to-download-all-of-the-free-ebooks-and-resources-in-my-free-ebooks-giveaway/
#400+ links
#Some links are to webpages or Sway, I'd like to save the link to these pages - still to do.
$saveTo = 'C:\MS_eBooks\' #where to place the eBooks
New-Item -Path $saveTo -ItemType Directory
$masterListLink = 'http://ligman.me/29zpthb' #link to the text file of links to the eBooks.
#Get an array of links, triming the header in the first line.
$eBookLinks = @((Invoke-WebRequest -Uri $masterListLink -MaximumRedirection 1).Content -split "`n" | % {$_.trim()} | select -Skip 1 )
foreach ($eBookLink in $eBookLinks) {
    try {
        $request = Invoke-WebRequest -Uri $eBookLink -MaximumRedirection 0 -ErrorAction Ignore #retrieve details on the eBook short URL
        if($request.StatusCode -like '30?') {
            $eBookURL = $request.Headers.Location #final URL to eBook
            $eBookLocal = "$saveTo$($eBookURL.Split('/')[-1])" #full path of eBook on disk
            Write-Output "Saving: $eBookLocal"
            Invoke-WebRequest -Uri $eBookURL -OutFile $eBookLocal
            Unblock-File $eBookLocal
        } else {
            Write-Warning "Failed: $eBookLink"
        }
    }
    catch {
        Write-Warning "Failed: $eBookLink"
    }
}
########## SCRIPT-06 ###########



















########## OUTPUT-06 ###########
#    Directory: C:\
#
#
# Mode                LastWriteTime         Length Name                                                                                                                                                                    
# ----                -------------         ------ ----                                                                                                                                                                    
# d-----        9/22/2016   9:50 PM                MS_eBooks  
# 
# Saving: D:\MS_eBooks\MICROSOFT_PRESS_EBOOK_DEPLOYING_WINDOWS_10_PDF.PDF
# Saving: D:\MS_eBooks\MICROSOFT_PRESS_EBOOK_DEPLOYING_WINDOWS_10_EPUB.EPUB
# Saving: D:\MS_eBooks\MICROSOFT_PRESS_EBOOK_DEPLOYING_WINDOWS_10_MOBI.MOBI
# Saving: D:\MS_eBooks\MICROSOFT_PRESS_EBOOK_INTRODUCING_WINDOWS_10_PDF.PDF
# Saving: D:\MS_eBooks\MICROSOFT_PRESS_EBOOK_INTRODUCING_WINDOWS_10_EPUB.EPUB
# ...
# ...
########## OUTPUT-06 ###########





















########## SCRIPT-07 ###########
# Scrape web pages and convert to PDF
$ElapsedTime = [System.Diagnostics.Stopwatch]::StartNew()
$pageType = 'majors'
$Count = 0
$Path = Split-Path $MyInvocation.MyCommand.Path -Parent

#Import list of URLs to each majors page (file has a header "href" and lines of URLs)
$PageLinks = Import-Csv "$Path\PageLinks.txt"
$TotalPages = $PageLinks.Count
$Activity = "Processing $TotalPages Pages"
$OutFile = "$Path\all_$pageType."
$AllHTML = $OutFile+"html"
$AllPDF = $OutFile+"pdf"
$AllDOCX = $OutFile+"docx"

#Begin creation of HTML file for pages of all majors
"<html><body>" | Out-File -FilePath $AllHTML -Encoding unicode

#Begin a loop to process each page
foreach ($link in $PageLinks) {

    #Build the name of the individual majors HTML page
    $pageName = ($link.href.Split("/")[-1]).Replace(".aspx",".html")
    
    #Show progress bar
    $Count++
    [int]$percentComplete = [Math]::Truncate($Count/$TotalPages * 100)
    Write-Progress -Activity $Activity -PercentComplete $percentComplete -Status "Please wait." -CurrentOperation "$percentComplete% - Working on $pageName"

    #Create an object that contains the content of a specific majors
    $pageObject = Invoke-WebRequest $link.href -UseDefaultCredentials
    
    #Get just the HTML in the page that contains the main content area
    $pageHTML = ($pageObject.ParsedHtml.body.getElementsByTagName('div') | Where {$_.getAttributeNode('class').Value -eq 'ms-rte-layoutszone-inner'}).innerHTML
    
    #Begin clean up of a few HTML elements in the main content area
    $pageHTML = $pageHTML.Replace(">Course Descriptions<","><")
    $pageHTML = $pageHTML.Replace(">Back to Top<","><")

    #Output the individual majors main content area to its own HTML file
    $pageName = ("{0:D3}" -f $count) + "_" + $pageName
    "<html><body>" + $pageHTML + "</body></html>" | Out-File -FilePath "$Path\$pageName" -Encoding unicode

    #Append the individual majors main content area to an HTML file of all majors and add a page break
    $pageHTML + "<br clear=all style='page-break-before:always'>" | Out-File -FilePath $AllHTML -Append -Encoding unicode

}

#Finish closing the HTML file containing all the majors
"</body></html>" | Out-File -FilePath $AllHTML -Append -Encoding unicode

Write-Progress -Activity $Activity -Completed -Status "Processing $pageType completed."
$tmMin = $ElapsedTime.Elapsed.Minutes.ToString() + "m"
$tmSec = $ElapsedTime.Elapsed.Seconds.ToString() + "s"
Write-Host "Processing completed in $tmMin $tmSec"

#Convert All majors HTML file to a PDF (must have Word installed)
$word = New-Object -ComObject Word.Application
$word.visible = $true
$doc = $word.documents.open($AllHTML)
[int]$wdFormatPDF = 17
$doc.saveas([ref]$AllPDF, [ref] $wdFormatPDF)
[int]$wdFormatDocumentDefault = 16
$doc.saveas([ref]$AllDOCX, [ref] $wdFormatDocumentDefault)
$doc.close()
$word.quit()
########## SCRIPT-07 ###########

























########## SCRIPT-08 ###########
# Uninstall an application listed in Programs and Feature
# Get all computers in 
$mycomps = Get-ADComputer -Filter * -SearchBase 'OU=UFIT,OU=Departments,OU=UF,dc=AD,dc=UFL,dc=EDU' -SearchScope Subtree
# Block of commands to run against the list of computers
[scriptblock]$cmd = {
    Stop-Process -name QuickTimePlayer
    $QuickTime = Get-WmiObject -Class Win32_Product | Where-object { $_.name -match 'Quicktime 7'}
    $QuickTime.Uninstall()
}
# Run the commands against each computer
foreach ($comp in $mycomps) {
    if (Test-Connection $comp -Count 1 -Quiet) {
        Invoke-Command -Computer $comp -Scriptblock $cmd
    }
}
########## SCRIPT-08 ###########












########## SCRIPT-09 ###########
#Send Email with Attachments from Command  Line
Send-MailMessage -To agcarey@ufl.edu -Subject "Goodbye" -Body "Thanks for all the fish." -From gasperj@ufl.edu -SmtpServer smtp.ufl.edu -Attachments 'C:\debug\resume.log'
########## SCRIPT-09 ###########















########## SCRIPT-10 ###########
#https://github.com/nickrod518/PowerShell-Scripts/blob/master/Send-CatFactMessage.ps1
$CatFact = (ConvertFrom-Json (Invoke-WebRequest -Uri 'http://catfacts-api.appspot.com/api/facts')).facts
Write-Output $CatFact
########## SCRIPT-10 ###########


















########## OUTPUT-10 ###########
#
# A domestic cat can sprint at about 31 miles per hour.
#
########## OUTPUT-10 ###########













# Resources
& start https://www.yammer.com/ufl.edu/groups/powershell



















########## SCRIPT-Bonus ###########
#Give PowerShell a Voice
Add-Type -AssemblyName System.Speech
$say = New-Object System.Speech.Synthesis.SpeechSynthesizer
#$say.GetInstalledVoices().VoiceInfo
$say.SelectVoice('Microsoft Zira Desktop')
$say.Speak('Thank you for joining us today.')
$say.SelectVoice('Microsoft David Desktop')
$say.Speak('PowerShell is Awesome!')
########## SCRIPT-Bonus ###########








########## Super-Bonus ###########
& start https://floobits.com/secretGeek/slackathon/file/Invoke-Chipotle/Invoke-Chipotle.ps1:1
& start https://floobits.com/secretGeek/slackathon/file/Send-Tweet/Send-Tweet.ps1:1
########## Super-Bonus ###########


########## Double-Bubble-Bonus ###########
# Update a Micrsoft Azure hosted WordPress installation from a GitHub repository
Import-Module AzureRM.Websites
Login-AzureRmAccount
$MyResourceGroup = 'wponmssql'
$MyResourceName = 'wponmssql'
Invoke-AzureRmResourceAction -ResourceGroupName $MyResourceGroup -ResourceType Microsoft.Web/sites -ResourceName $MyResourceName -Action sync -ApiVersion 2015-08-01 -Force -Verbose
########## Double-Bubble-Bonus ###########