﻿##############################################################################################################################
# START - agcarey-peer2peer.ps1
##############################################################################################################################

##############################################################################################################################
# Using AD PS Drive
##############################################################################################################################
Import-module ActiveDirectory
#PSDrives are just another way to access AD

#Navigate AD like file system
cd "AD:\OU=UFAD-Test,DC=ad,DC=ufl,DC=edu"

dir

#cd is an alias for the Powershell Cmdlet set-location
cd "OU=test-permissions"

#dir is an alias for the Powershell Cmdlet get-childitem
dir

cd "OU=OU2a,OU=OU2"

dir

cd ..

#get different types of objects by filtering with where
$OUs = dir -Recurse |where objectclass -eq 'organizationalunit'
$OUs

$ServiceAccounts = dir -Recurse |where objectclass -eq 'user'
$ServiceAccounts

$Groups= dir -Recurse |where objectclass -eq 'group'
$Groups

#to find other Powershell Drives:
get-psprovider
cd cert:
cd HKLM:
cd HKCU:

##############################################################################################################################
# Using AD PS Drive with Out-Gridview
##############################################################################################################################

##out-gridview with the passthru parameter requires PowerShell Version 3

cd "AD:\OU=UFAD-Test,DC=ad,DC=ufl,DC=edu"

#Get all AD objects in the OU and sub-OUs
$allObjects=dir -Recurse
$allObjects

#get a list of the types of objects and use out-gridview to select the object type
$objecttype=$allobjects|select -Unique objectclass|sort objectclass|Out-GridView -PassThru
$objecttype

#get all objects that are of the selected object type
$Objects = dir -Recurse |where objectclass -eq $ObjectType.objectclass
$objects


##############################################################################################################################
# Finding linked GPOs
##############################################################################################################################

#change to a more interesting OU for the next example
cd "AD:\OU=CNS,OU=IT,OU=Provost,OU=Departments,OU=UF,DC=ad,DC=ufl,DC=edu"

############################################################
##Next three commands are the same as the example above
##Just executed on the more interesting OU

#Get all AD objects in the OU and sub-OUs
$allObjects=dir -Recurse -Properties *

#get a list of the types of objects and use out-gridview to select the object type
$objecttype=$allobjects|select -Unique objectclass|sort objectclass|Out-GridView -PassThru

#get all objects that are of the selected object type
$Objects = dir -Recurse |where objectclass -eq $ObjectType.objectclass
$Objects
############################################################

#Create an empty Collection for the results
$GPOs=@()


foreach ($OU in $Objects)
{
    
    #foreach OU get all of the GPOs that are directly linked (not inherited)
    $GPOs +=(Get-GPInheritance -Target $Ou.distinguishedname).gpolinks|Select displayname, gpoid, target
}


#show all GPOs linked anywhere in the OU structure
$GPOs|Out-GridView -Title "GPOs"

#output a list of distinct GPOs applied (remove duplicates)
$GPOs| select -Unique Displayname, gpoid|out-gridview



##############################################################################################################################
# Additional Resources
##############################################################################################################################

#Working with Certificates using cert: PSDrive
start-process https://blogs.technet.microsoft.com/scotts-it-blog/2014/12/30/working-with-certificates-in-powershell/

#Use out-gridview to select remote computers to run a powershell script against
start-process http://mikefrobbins.com/2014/09/11/creating-a-simplistic-gui-interface-with-out-gridview/

#More Out-Gridview examples
start-process https://mcpmag.com/articles/2013/01/08/pshell-gridview.aspx
start-process https://blogs.technet.microsoft.com/heyscriptingguy/2013/03/22/explore-active-directory-users-with-powershell-out-gridview/

#More on AD: PSDrive
start-process https://blogs.technet.microsoft.com/heyscriptingguy/2013/03/18/playing-with-the-ad-drive-for-fun-and-profit/
start-process https://blogs.technet.microsoft.com/heyscriptingguy/2013/03/20/use-powershell-to-find-non-default-user-properties-in-ad/

##############################################################################################################################
# END - agcarey-peer2peer.ps1
##############################################################################################################################
