﻿##############################################################################################################################
# START - exa-peer2peer.ps1
##############################################################################################################################

##############################################################################################################################
# Change CCM agent cache size
##############################################################################################################################

#Query Cache size
$CacheQuery = Get-WmiObject -Namespace ROOT\CCM\SoftMgmtAgent -Class CacheConfig
$CacheQuery.Size = 10000 # MByte
$CacheQuery.Put() | Out-Null # set new size to above
#Restart CcmExec service
Restart-Service -Name CcmExec

##############################################################################################################################
# Determine if local CCM agent believes there is a pending reboot for this system
##############################################################################################################################

Invoke-WmiMethod -Namespace "ROOT\ccm\ClientSDK" -Class CCM_ClientUtilities -Name DetermineIfRebootPending | Select-Object -ExpandProperty RebootPending

##############################################################################################################################
# A popup notification, code layout A
##############################################################################################################################

$notificationTitle = "Technology Support Services - Notification"
$notificationBody = 'Your computer is reporting a "Pending Reboot" state.' + "`n`n" + `
                    'Please restart at your earliest convenience.' + "`n`n" + `
                    'Alternatively, if your computer is left on and awake overnight, it will automatically reboot between 11pm-5am.'
$wshell = New-Object -ComObject Wscript.Shell
$wshell.Popup($notificationBody,0,$notificationTitle,0x0)

##############################################################################################################################
# A popup notification, code layout B
##############################################################################################################################

(New-Object -ComObject Wscript.Shell).Popup('Your computer is reporting a "Pending Reboot" state.' + "`n`n" + `
                    'Please restart at your earliest convenience.' + "`n`n" + `
                    'Alternatively, if your computer is left on and awake overnight, it will automatically reboot between 11pm-5am.',
                    0,
                    "Technology Support Services - Notification",0x0)

##############################################################################################################################
# Crawl a directory structure and report the folder sizes
##############################################################################################################################

Function Get-FolderSize {
    Begin {
        $fso = New-Object -comobject Scripting.FileSystemObject
    }

    Process {
        $path = $input.fullname
        $folder = $fso.GetFolder($path)
        $size = $folder.size
        [PSCustomObject]@{'Name' = $path;'Size' = "{0:N4}" -f ($size / 1GB) + " GB"}
    }
}

Get-ChildItem "C:\" -Directory -Recurse -ErrorAction Ignore | Get-FolderSize | ? {$_.size -gt 100MB} | sort size -Descending

##############################################################################################################################
# Get AD user by UFID
##############################################################################################################################

import-module activedirectory 
Get-ADUser -Filter "employeeID -like '72939560'" -Properties * | select name, UserPrincipalName

##############################################################################################################################
# Write to the registry, in this case set a custom value for the warranty expiration date of this computer
##############################################################################################################################

# check uf the UF 32bit path exists, if not then create it
if(!(Test-Path "HKLM:\SOFTWARE\UF")) {
    New-Item "HKLM:\SOFTWARE" -Name "UF"
}
# check uf the UF 64bit path exists, if not then create it
if(!(Test-Path "HKLM:\SOFTWARE\Wow6432Node\UF")) {
    New-Item "HKLM:\SOFTWARE\Wow6432Node" -Name "UF"
}
# check uf the WarrantyExpDate 32bit item exists, if not then create it, and set it
if((Get-ItemProperty "HKLM:\SOFTWARE\UF").WarrantyExpDate -ne $null) {
    Set-ItemProperty "HKLM:\SOFTWARE\UF" -Name "WarrantyExpDate" -Value "2017-01-20"
}else{
    New-ItemProperty "HKLM:\SOFTWARE\UF" -Name "WarrantyExpDate" -Value "2017-01-20" | Out-Null
}
# check uf the WarrantyExpDate 64bit item exists, if not then create it, and set it
if((Get-ItemProperty "HKLM:\SOFTWARE\Wow6432Node\UF").WarrantyExpDate -ne $null) {
    Set-ItemProperty "HKLM:\SOFTWARE\Wow6432Node\UF" -Name "WarrantyExpDate" -Value "2017-01-20"
}else{
    New-ItemProperty "HKLM:\SOFTWARE\Wow6432Node\UF" -Name "WarrantyExpDate" -Value "2017-01-20" | Out-Null
}

##############################################################################################################################
# Get the current date/time with custom formatting, for appending to output filename
##############################################################################################################################

# date for appending to file names
$date       = $(get-date -f MM-dd-yyyy_hh-mm-ss) #http://winpowershell.blogspot.com/2006/09/systemdatetime-parseexact.html
# output file
$output    = "Get-CombinedInventory_$date.csv"
Write-Host $output

##############################################################################################################################
# Go to the Dell driver CABs page and fetch URLs for relevant pages
##############################################################################################################################

# create web request for the index site and get us a list of desired links
$indexDoc = Invoke-WebRequest "http://en.community.dell.com/techcenter/enterprise-client/w/wiki/2065.aspx"
$indexLinks = $indexDoc.Links
$indexLinks = $indexLinks | ?{ $_.innerText -notlike "*aio*" -and ($_.innerText -like "*winpe*10*" -or (($_.innerText -like "*latitude*" -or $_.innerText -like "*optiplex*" -or $_.innerText -like "*precision*") -and ($_.innerText -like "*windows*7*driver*" -or $_.innerText -like "*windows*10*driver*" )))}
$indexLinks | select href | sort href

##############################################################################################################################
# Connect to remote Exchange management shell
##############################################################################################################################

$cred = Get-Credential
$session = New-PSSession -ConfigurationName Microsoft.Exchange -ConnectionUri http://exmbxprd01.ad.ufl.edu/Powershell/ -Authentication Kerberos -Credential $cred
Import-PSSession $session

##############################################################################################################################
# Windows 8/10 App cleanup (these require an elevated shell)
##############################################################################################################################

# To get currently available packages:
Get-AppxPackage -AllUsers | select Name, PackageFullName | sort Name
# To get currently available provisioned packages:
Get-AppxProvisionedPackage -Online | select DisplayName, PackageName | sort DisplayName
# To remove particular package(s) via name matching:
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*name*"} | Remove-AppxProvisionedPackage -online
# To remove particular provisioned package(s) via name matching:
Get-AppxPackage -AllUsers | ?{$_.name -like "*name*"} | Remove-AppxPackage
# Here is what we usually want to remove:
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*3DBuilder*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*MicrosoftOfficeHub*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*MicrosoftSolitaireCollection*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*OneConnect*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*OneNote*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*SkypeApp*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*windowscommunicationsapps*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*WindowsFeedbackHub*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*Xbox*"} | Remove-AppxProvisionedPackage -online
Get-AppxProvisionedPackage -Online | ?{$_.PackageName -like "*Zune*"} | Remove-AppxProvisionedPackage -online
Get-AppxPackage -AllUsers | ?{$_.name -like "*3DBuilder*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*MicrosoftOfficeHub*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*MicrosoftSolitaireCollection*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*OneConnect*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*OneNote*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*SkypeApp*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*windowscommunicationsapps*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*WindowsFeedbackHub*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*XboxApp*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*XboxIdentityProvider*"} | Remove-AppxPackage
Get-AppxPackage -AllUsers | ?{$_.name -like "*Zune*"} | Remove-AppxPackage

##############################################################################################################################
# Send an E-Mail
##############################################################################################################################

# init all we need to send an email out to cherwell
$emailServer = "smtp.ufl.edu"
$emailFrom = "exa@ufl.edu"
$emailTo = "exa@ufl.edu"
$emailSubject = ">>> peer2peer test email <<<"
$emailBody = "Yay this is the message body!"
        
# try to send the message
try {
    Write-Host "`nAttempting to send email from $emailFrom to $emailTo..."
    # if the from address isn't in the GAL, this will fail, so the tech must put in a valid gatorlink for this to work
    Send-MailMessage -From $emailFrom -To $emailTo -Subject $emailSubject -Body $emailBody -SmtpServer $emailServer -ErrorAction Stop
} catch {
    Write-Host "`nThere was an Error sending the email:"
    Write-Host " - Source:`t" $_.Exception.Source
    Write-Host " - Message:`t" $_.Exception.Message
    Write-Host " - Exception:`t" $_.Exception.InnerException
    Write-Host "`nDouble check that the sender's gatorlink was valid, properly input, and has an existing mailbox,`nbecause it is used as the from address."
}

##############################################################################################################################
# THE END
############################################################################################################################## 